alter table inzet_vw add WEBFLEET_ID varchar(30) ; 

commit;

INSERT INTO ALGEMENEINSTELLINGEN  (NUMMER,             VELD ,VELDTYPE,ZICHTBAAR, WIJZIGBAAR,BEVOEGDHEID, ASSTRING  ,  ASINTEGER,ASDOUBLE,ASDATE     ,LOOKUPTABLE,LOOKUPFIELD,RESULTFIELD_1,RESULTFIELD_2,OMSCHRIJVING,TOEGEVOEGD,GEWIJZIGD)
                           VALUES (   320, 'OpdrachtnrLengteWaarschuwing',       1,      'J',       'N' ,          5,       'J' ,
       NULL,    NULL, '01/01/2019 00:00:00.000',NULL,NULL,NULL,NULL, 'Waarschuwen als opdrachtnr te lang is voor Exact','6.4.2022','6.4.2022');

alter table ADRESBOEK add Landcode varchar(2);
alter table UURSOORT add RELEVANT_VOOR_APP varchar(1);
commit;
update uursoort set RELEVANT_VOOR_APP = ZICHTBAAR ;
commit;

SET TERM ^^ ;
CREATE PROCEDURE P_BEWAAR_UREN_VAN_CHAUFFEURSAPP (
  TRANSPORT Integer, 
  VAN Date, 
  TOT Date, 
  PAUZE Integer, 
  UURSOORT Integer, 
  UREN Numeric(12,2), 
  SCAN Char(1))
AS
declare variable ordernr   integer;
declare variable rit integer;
declare variable werknemer integer;

declare variable jaar integer;
declare variable week integer;
declare variable dag  integer;
declare variable werknummer integer;
declare variable jaar_week integer;
declare variable scanNummer integer;
declare variable einde_werkzaamheden_zonder_pauze date;
declare variable uursoort_PAUZE integer;


begin
  
 
 
 select ordernr, RITNUMMER from INZET_VW where nummer= :transport into :ordernr, :rit ; 
  
 select werk from order1 where nummer = :ordernr into :werknummer;

 
 select werknemer from RITTEN where NUMMER=:rit into :werknemer ; 
  
              
        jaar =  extract (year  from :VAN) ;
        week =  extract (WEEKDAY  from :VAN) ;                    
        dag  =  extract (WEEKDAY from :VAN) ;                    
  
                      
  jaar_week = (jaar-2000)*100 + week ;
                 
  einde_werkzaamheden_zonder_pauze  = :van + ( :uren/24 ) ;                    
  
  if ( SCAN = 'J') THEN BEGIN
                                         
                 
    if (:PAUZE > 0) then begin 
    
      /*Check of uursoort Pauze bestaat, en zo niet, hier aanmaken*/
      select min(nummer) from UURSOORT U where upper(U.OMSCHRIJVING) like '%PAUZE%' into uursoort_PAUZE ;
    
      /* Geen "pauze"" gevonden maar wel pauze minuten opgegeven: aanmaken */                                                                                                      
      
      if ( uursoort_PAUZE = 0 ) then begin 

        select coalesce ( max(nummer) +1 , 1 ) from UURSOORT  into :uursoort_PAUZE ;

        INSERT INTO UURSOORT (NUMMER, KODE, OMSCHRIJVING, GROOTBOEK, FAKTUREERBAAR, TRANSPORTMODULE, BUSINESSAREA, ZICHTBAAR, ARTIKEL, STOP, DEFAULT_WERK, DEFAULT_ORDER, KLEUR, BARCODE_INTERN, TELTMEE, RELEVANT_VOOR_APP) 
        VALUES ( :uursoort_PAUZE,9999, 'Pauze', NULL, 'N', 'N', NULL, 'J', NULL, 'N', NULL, NULL, 'clRed',:uursoort_PAUZE  , 'J', 'N');

                        
        
      end
      
      
    end   
    
    select coalesce( max(nummer)+1,1) from URENSCAN_LOG into :scanNummer ;                       

    
    insert into URENSCAN_LOG( NUMMER, DATUM, WERKNEMER, UURSOORT, TIJDSTEMPEL_VANAF, TIJDSTEMPEL_TOT, WERK, BEURT, ORDERNUMMER, VERWERKT )   
    values
                ( :scanNummer,
                  :VAN,
                  :werknemer,
                  :UURSOORT,
                  :VAN,
                  :einde_werkzaamheden_zonder_pauze,                           
                  :werknummer,
                  0,
                  :ordernr,
                  'J' )  ; 
                             
    /*Als er pauze opgegeven is, deze achter de werkzaamheden toevoegen*/
    
    if (:PAUZE > 0) then begin 
     
      insert into URENSCAN_LOG( NUMMER, DATUM, WERKNEMER, UURSOORT, TIJDSTEMPEL_VANAF, TIJDSTEMPEL_TOT, WERK, BEURT, ORDERNUMMER, VERWERKT )   
      values
                ( :scanNummer+1,
                  :einde_werkzaamheden_zonder_pauze,
                  :werknemer,
                  :uursoort_PAUZE,
                  :VAN,
                  :einde_werkzaamheden_zonder_pauze + (:pauze/(24*60) ),                           
                  :werknummer,
                  0,
                  :ordernr,
                  'J' )  ;
    end  
    

  END ELSE BEGIN 
                      
  
    /*direct naar de urenregistratie}*/


    insert into urenregistratie(WERKNEMER,werk, jaar_Week, DAG, volgnummer, datum,uursoort, ordernummer,

                               aantalUren, volgnummer2, scan, beurt )  

    values
                ( :werknemer,
                :werknummer,
                :jaar_week,                           
                :dag,
                1,                                                         
                :van,
                :uursoort,
                :ordernr,
                :uren, 1, -1, -1 )  ;
                 
  
     
  
  END
                 
  
end ^^
SET TERM ; ^^

alter table MOBILEREPORTS add Hulpmateriaal_CheckboxWaarden  VARCHAR(    20) ;



CREATE TABLE rep_dic_table
(table_name VARCHAR(60) NOT NULL,
 table_alias VARCHAR(60) NOT NULL,
PRIMARY KEY (table_name));

CREATE UNIQUE INDEX rep_table_name_idx ON rep_dic_table (table_name);

/* create data dictionary field table */

CREATE TABLE rep_dic_rb_field
(table_name VARCHAR(60) NOT NULL,
field_name VARCHAR(60) NOT NULL,
field_alias VARCHAR(60),
datatype VARCHAR(60),
selectable CHAR(1),
searchable CHAR(1),
sortable CHAR(1),
autosearch CHAR(1),
mandatory CHAR(1),
PRIMARY KEY (table_name, field_name));

CREATE UNIQUE INDEX rb_table_field_name_idx  ON rep_dic_rb_field (table_name, field_name);
CREATE UNIQUE INDEX rb_table_field_alias_idx ON rep_dic_rb_field (table_name, field_alias);


CREATE TABLE rep_dic_rb_join
(table_name1 VARCHAR(60) NOT NULL,
table_name2 VARCHAR(60) NOT NULL,
join_type VARCHAR(60),
field_names1 VARCHAR(255),
operators VARCHAR(60),
field_names2 VARCHAR(255),
PRIMARY KEY (table_name1, table_name2));

CREATE UNIQUE INDEX rb_table1_table2_idx ON rep_dic_rb_join (table_name1, table_name2);

SET TERM ^^ ;
CREATE OR ALTER PROCEDURE P_TOTAALAANTAL_MACHINES_VAN_PLANBORD (
  PLANBORD Integer)
 returns (
  AANTAL Integer)
SQL SECURITY INVOKER
AS
declare variable groepen varchar(250) ; 
declare variable artikel integer;  
declare variable N integer;  

begin
  /* code */                                  
  
 aantal = 0 ;   
 select ARTIKELGROEPEN  from PLANBORD_SETTINGS where nummer = :planbord into :groepen ;
                                    
        
 for execute statement 'select nummer from artikel where ( BEZETTINGSGRAAD=''J'' ) AND ( artikelnr <> ''0'' ) and groep in ('|| groepen ||')' into :artikel do begin    
 
 
   select bezit from P_TOTAALBEZIT( :Artikel, 1 ) into :N;
 
   aantal = aantal + N; 
          
   
  end 
         
  
  suspend;
end ^^
SET TERM ; ^^

update alginst set BUILD = 32522 ;


SET TERM ^^ ;
CREATE OR ALTER PROCEDURE P_TOTAALAANTAL_MACHINES_VAN_PLANBORD (
  PLANBORD Integer)
 returns (
  AANTAL Integer)
SQL SECURITY INVOKER
AS
declare variable groepen varchar(250) ; 
declare variable artikel integer;  
declare variable N integer;  

begin
  /* code */                                  
  
 aantal = 0 ;   
 select ARTIKELGROEPEN  from PLANBORD_SETTINGS where nummer = :planbord into :groepen ;
                                    
        
 for execute statement 'select nummer from artikel where ( BEZETTINGSGRAAD=''J'' ) AND ( artikelnr <> ''0'' ) and groep in ('|| groepen ||')' into :artikel do begin    
 
 
   select bezit from P_TOTAALBEZIT( :Artikel, 1 ) into :N;
 
   aantal = aantal + N; 
          
   
  end 
         
  
  suspend;
end ^^
SET TERM ; ^^



CREATE TABLE IVS_DOCUMENTEN 
(
  SETTING                            INTEGER         NOT NULL,
  NUMMER                             INTEGER         NOT NULL,
  OMSCHRIJVING                       VARCHAR(   100)  COLLATE NONE,
  REPORTNAME                         VARCHAR(   100)  COLLATE NONE,
  MENUTEKST                          VARCHAR(   100)  COLLATE NONE,
  TOOLBUTTONTEXT                     VARCHAR(   100)  COLLATE NONE,
  IMAGEINDEX                         INTEGER,
  DOCTYPE                               CHAR(    30)  COLLATE NONE,
  BESTANDSFORMAAT                       CHAR(     1)  COLLATE NONE,
  OUTPUTDEVICE                          CHAR(     1)  COLLATE NONE,
  PEILDATUM_RELEVANT                    CHAR(     1)  COLLATE NONE,
  PL_KLANT                              CHAR(     1)  COLLATE NONE,
  PL_WERK                               CHAR(     1)  COLLATE NONE,
  PL_ORDER                              CHAR(     1)  COLLATE NONE,
  PL_LEVERING                           CHAR(     1)  COLLATE NONE,
  PL_MACHINE                            CHAR(     1)  COLLATE NONE,
  PL_FACTUREN                           CHAR(     1)  COLLATE NONE,
  PLTAG_1                            INTEGER,
  PLTAG_2                            INTEGER,
  PLTAG_3                            INTEGER,
  PLTAG_4                            INTEGER,
  PLTAG_5                            INTEGER,
  PLTAG_6                            INTEGER,
  PLTAG_7                            INTEGER,
  PLTAG_8                            INTEGER,
  PLTAG_9                            INTEGER,
  PLTAG_10                           INTEGER,
  SCHERM_KWO_K                          CHAR(     1)  COLLATE NONE,
  SCHERM_KWO_W                          CHAR(     1)  COLLATE NONE,
  SCHERM_KWO_O                          CHAR(     1)  COLLATE NONE,
  SCHERM_KWO_L                          CHAR(     1)  COLLATE NONE,
  SCHERM_ARTIKEL                        CHAR(     1)  COLLATE NONE,
  SCHERM_LIJST_KLANT                    CHAR(     1)  COLLATE NONE,
  SCHERM_LIJST_WERK                     CHAR(     1)  COLLATE NONE,
  SCHERM_LIJST_ORDER                    CHAR(     1)  COLLATE NONE,
  SCHERM_LIJST_MACHINES                 CHAR(     1)  COLLATE NONE,
  ARCHIVEREN                            CHAR(     1)  COLLATE NONE,
 CONSTRAINT PK_IVS_DOCUMENTEN PRIMARY KEY (SETTING, NUMMER)
);
SET TERM ^^ ;
CREATE OR ALTER PROCEDURE P_NODEPAD (
  NODE Integer, 
  NIVEAU Integer)
 returns (
  NODEPAD VarChar(4500))
SQL SECURITY INVOKER
AS
begin
   suspend ;
end ^^
SET TERM ; ^^

COMMIT;

SET TERM ^^ ;
CREATE OR ALTER PROCEDURE P_NODEPAD (
  NODE Integer, 
  NIVEAU Integer)
 returns (
  NODEPAD VarChar(4500))
SQL SECURITY INVOKER
AS
/*
  You can change this template in the template editor:
  File | Preferences | Object Templates

  Procedure:

  Author   : , 
  Date     : 19-8-2022 9:13:12
  Purpose  :
  Params
  ------
  <param>  : <purpose>
*/
declare variable s varchar(254); 
declare variable s2 varchar(254); 
declare variable parentnode integer ;

begin
  /* code */     
  
  if (niveau=null) then niveau = 0 ;                         
  if (niveau is null) then niveau = 0 ;                         
  
  niveau = niveau + 1 ;
  
  nodepad = ''; /* niet NULL, anders wordt alles NULL} */
  
  Select omschrijving, parent_node from artikel_nodes where nummer = :node into :s, :parentnode ; 
  
  if (s is null) then 
  
   suspend ;
  
  else begin  
   
                                                                                                   
   nodepad = '->' || :s ;
  
    if (( :niveau > 10) or ( parentnode=0 ))then 
      suspend ;
    else begin
  
      select NODEPAD from P_NODEPAD(:parentnode, :niveau ) into :s2 ;
      nodepad = nodepad || :s2 ; 
      suspend;                          
    
    end
    
  end  
    
end ^^
SET TERM ; ^^

COMMIT;


SET TERM ^^ ;
CREATE OR ALTER PROCEDURE P_ARTIKELPAD (
  ARTIKEL Integer)
 returns (
  ARTIKELPAD VarChar(5000))
SQL SECURITY INVOKER
AS
/*
  Procedure: P_ArtikelPad

  Author   : Dirk Janssens 
  Date     : 19-8-2022 8:58:17
  Purpose  : Geeft van een artikel het "pad" terug als string" : Hoofdgroep->GRoep->Subgroep1->Subgroep2....
  Params
  ------
  <param>  : <purpose>
*/

declare variable G integer ;
declare variable hoofdgroep varchar(50) ; 
declare variable groep varchar(50) ; 
declare variable node integer ;
declare variable nodepad varchar(5000) ;
begin
  /* code */  

  select groep from artikel where nummer = :ARTIKEL into :G ;
  
  
  Select omschrijving from hoofdgroep where hoofdgroep.nummer =(select hoofdgroep from groep where nummer = :G) into :hoofdgroep ;
  Select omschrijving from GROEP where nummer = :G into :groep ; 
  select node from artikel where nummer = :artikel into :node ;

  ARTIKELPAD = :hoofdgroep||'->'||groep ;
                                  
  
  if ( node>0 ) then begin 
    select nodepad from  P_NODEPAD( :NODE,0 ) into :nodepad ; 

    ARTIKELPAD = ARTIKELPAD || nodepad ;  

  end
  
  
  suspend ;
     
end ^^
SET TERM ; ^^


ALTER TABLE GROEP ADD IVS_CATEGORIE INTEGER ;

ALTER TABLE HOOFDGROEP ADD TAB_TYPE CHAR(1) ;
COMMIT;
UPDATE HOOFDGROEP SET TAB_TYPE = TAB_MACHINESPECIFICATIES ;
commit ;

SET TERM ^^ ;
CREATE OR ALTER PROCEDURE P_ARITKEL_TYPEWAARDENOVERNEMEN (
  ARTIKEL Integer, 
  OVERSCHRIJVEN Char(1))
SQL SECURITY INVOKER
AS
declare variable artikeltype integer ; 


begin

  select type from artikel where nummer = :artikel into :artikeltype  ;
  
  if ( :artikeltype > 0  ) then begin 
  

    if ( :OVERSCHRIJVEN = 'J') then begin 

      update ARTIKEL set OH_MERK        =(select oh_merk        from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set OH_TYPENR      =(select OH_TYPENR      from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set OH_HEFVERMOGEN =(select OH_HEFVERMOGEN from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set GEWICHT        =(select GEWICHT        from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set OH_HOOGTE      =(select OH_HOOGTE      from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set WERKHOOGTE     =(select WERKHOOGTE     from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set BRANDSTOF      =(select BRANDSTOF      from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set TRANSPORTCAT   =(select TRANSPORTCAT   from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set OH_MIN_L       =(select OH_MIN_L       from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set OH_MIN_B       =(select OH_MIN_B       from artikel where nummer = :artikeltype ) where nummer = :artikel ;
      update ARTIKEL set OH_MIN_H       =(select OH_MIN_H       from artikel where nummer = :artikeltype ) where nummer = :artikel ;
    
    end else begin 
  
      update ARTIKEL set OH_MERK        =(select oh_merk        from artikel where nummer = :artikeltype ) where nummer = :artikel and oh_merk        is not null ;
      update ARTIKEL set OH_TYPENR      =(select OH_TYPENR      from artikel where nummer = :artikeltype ) where nummer = :artikel and OH_TYPENR      is not null;
      update ARTIKEL set OH_HEFVERMOGEN =(select OH_HEFVERMOGEN from artikel where nummer = :artikeltype ) where nummer = :artikel and OH_HEFVERMOGEN is not null;
      update ARTIKEL set GEWICHT        =(select GEWICHT        from artikel where nummer = :artikeltype ) where nummer = :artikel and GEWICHT        is not null;
      update ARTIKEL set OH_HOOGTE      =(select OH_HOOGTE      from artikel where nummer = :artikeltype ) where nummer = :artikel and OH_HOOGTE      is not null;
      update ARTIKEL set WERKHOOGTE     =(select WERKHOOGTE     from artikel where nummer = :artikeltype ) where nummer = :artikel and WERKHOOGTE     is not null;
      update ARTIKEL set BRANDSTOF      =(select BRANDSTOF      from artikel where nummer = :artikeltype ) where nummer = :artikel and BRANDSTOF      is not null;
      update ARTIKEL set TRANSPORTCAT   =(select TRANSPORTCAT   from artikel where nummer = :artikeltype ) where nummer = :artikel and TRANSPORTCAT   is not null;
      update ARTIKEL set OH_MIN_L       =(select OH_MIN_L       from artikel where nummer = :artikeltype ) where nummer = :artikel and OH_MIN_L       is not null;
      update ARTIKEL set OH_MIN_B       =(select OH_MIN_B       from artikel where nummer = :artikeltype ) where nummer = :artikel and OH_MIN_B       is not null;
      update ARTIKEL set OH_MIN_H       =(select OH_MIN_H       from artikel where nummer = :artikeltype ) where nummer = :artikel and OH_MIN_H       is not null;
    
    end
      
 
  
  end
  
  


  
end ^^
SET TERM ; ^^

commit ;

ALTER TABLE ARTIKEL ADD Motortype    varchar(50) ;
ALTER TABLE ARTIKEL ADD Motornummer1 varchar(50) ;
ALTER TABLE ARTIKEL ADD Motornummer2 varchar(50) ;
ALTER TABLE ARTIKEL ADD Motornummer3 varchar(50) ;

ALTER TABLE ARTIKEL ADD Schemanummer        varchar(50) ;
ALTER TABLE ARTIKEL ADD Handleidingnummer    varchar(50) ;
ALTER TABLE ARTIKEL ADD SparePartsBoeknummer varchar(50) ;

ALTER TABLE ARTIKEL ADD VALREM_ARTIKELNR varchar(50) ;
ALTER TABLE ARTIKEL ADD VALREM_SERIENR   varchar(50) ;
ALTER TABLE ARTIKEL ADD DEACTIVERING DATE ;
ALTER TABLE ARTIKEL ADD VERKOOPDATUM DATE ;
ALTER TABLE ARTIKEL ADD VALREM varchar(50) ;

commit ;

update GROEP set IVS_CATEGORIE = 2 where HOOFDGROEP = 4 ;  
update GROEP set IVS_CATEGORIE = 6 where HOOFDGROEP = 5 ;
update GROEP set IVS_CATEGORIE = 6 where HOOFDGROEP = 9 ;


ALTER TABLE HOOFDGROEP ADD TAB_KENMERKEN CHAR(1) ;
COMMIT;
UPDATE HOOFDGROEP SET TAB_KENMERKEN = TAB_MACHINESPECIFICATIES ;
commit ;
   


ALTER TABLE ARTIKEL ADD Motortype    varchar(50) ;
ALTER TABLE ARTIKEL ADD Motornummer1 varchar(50) ;
ALTER TABLE ARTIKEL ADD Motornummer2 varchar(50) ;
ALTER TABLE ARTIKEL ADD Motornummer3 varchar(50) ;

ALTER TABLE ARTIKEL ADD Schemanummer        varchar(50) ;
ALTER TABLE ARTIKEL ADD Handleidingnummer    varchar(50) ;
ALTER TABLE ARTIKEL ADD SparePartsBoeknummer varchar(50) ;

ALTER TABLE ARTIKEL ADD VALREM_ARTIKELNR varchar(50) ;
ALTER TABLE ARTIKEL ADD VALREM_SERIENR   varchar(50) ;
ALTER TABLE ARTIKEL ADD DEACTIVERING DATE ;
ALTER TABLE ARTIKEL ADD VERKOOPDATUM DATE ;
ALTER TABLE ARTIKEL ADD VALREM varchar(50) ;

commit ;

update GROEP set IVS_CATEGORIE = 2 where HOOFDGROEP = 4 ;  
update GROEP set IVS_CATEGORIE = 6 where HOOFDGROEP = 5 ;
update GROEP set IVS_CATEGORIE = 6 where HOOFDGROEP = 9 ;


ALTER TABLE HOOFDGROEP ADD TAB_KENMERKEN CHAR(1) ;
COMMIT;
UPDATE HOOFDGROEP SET TAB_KENMERKEN = TAB_MACHINESPECIFICATIES ;
commit ;
   
ALTER table ORDER4 ADD VOLGORDE INTEGER ;
COMMIT;
update order4 set volgorde = volgnummer ;
commit;

ALTER table ORDER2 ADD VOLGORDE INTEGER ;
COMMIT;
update order2 set volgorde = volgnummer ;
commit;

CREATE TABLE REPORTS 
(
  ITEMID                       INTEGER         NOT NULL,
  FOLDERID                     INTEGER,
  REPORTNAME                      CHAR(60),
  REPSIZE                      INTEGER,
  ITEMTYPE                     INTEGER,
  TEMPLATE                    MEMOVELD,
  MODIFIED                        DATE,
  DELETED                         DATE,
  BLOCKEVENTS                     CHAR(1),
  MAILBODYTEKST                INTEGER,
  MAILBODYSUBJECT              INTEGER,
  CONSTRAINT PK_REPORTS PRIMARY KEY (ITEMID)
);

CREATE TABLE REPORT_FOLDERS 
(
  FOLDERID                INTEGER         NOT NULL,
  REPORTNAME                 CHAR(60) NOT NULL,
  PARENTID                INTEGER,
  MODIFIED                   DATE,
  DELETED                    DATE,
  CONSTRAINT PK_REPORT_FOLDERID PRIMARY KEY (FOLDERID)
);


commit;

insert into REPORTS select * from REPITEMS_3 ;
insert into REPORT_FOLDERS select * from REPFOLDERS;



alter table mobile_afwijkende_leveringen add nBesteld double precision ;
alter table mobile_afwijkende_leveringen add nGeleverd double precision ; 
alter table mobile_afwijkende_leveringen add nRetour double precision ;  
commit;

update alginst set BUILD = 32530 ;


alter table adresboek alter naam drop NOT null;
alter table adresboek alter naam drop NOT null;
alter table ADRESBOEK add LANDCODE VARCHAR(2) ;
alter table KLANT add EIGEN_Vertegenwoordiger integer ;

commit;

alter table klant add negeer_brandstof char(1) ;
alter table klant add negeer_transport char(1) ;
commit;
update klant set negeer_brandstof = 'N';
update klant set negeer_transport = 'N';
commit;
update klant set negeer_brandstof = 'J' where nummer in (select klant from klanten_zonder_brandstof ) ;
update klant set negeer_transport = 'J' where nummer in (select klant from klanten_zonder_transport ) ;
commit;

alter table IVS_DOCUMENTEN add SOORT integer ; 

CREATE TABLE IVS_DOCUMENTSOORT 
(
  NUMMER                                    INTEGER         NOT NULL,
  INHUURDOCUMENT                               CHAR(1),
  FACTUUR                                      CHAR(1),
  ORDERBON                                     CHAR(1),
  RECIP_KLANT_EMAIL1                           CHAR(1),
  RECIP_KLANT_EMAIL2                           CHAR(1),
  RECIP_PROJECTLEIDER                          CHAR(1),
  RECIP_BESTELLER                              CHAR(1),
  RECIP_ORDERCONTACTEN                         CHAR(1),
  RECIP_INTERN                                 CHAR(1),
  RECIP_EIGENVERTEGENWOORDIGER                 CHAR(1),
  RECIP_VERTEGENWOORDIGE                       CHAR(1),
  CONSTRAINT PK_IVS_DOCUMENTSOORT PRIMARY KEY (NUMMER)
);



commit; 

update IVS_DOCUMENTEN set SOORT = 3 ;
commit;



INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (1, 'Factuur'                              , 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (2, 'Inhuurdocument'                       , 'J', 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (3, 'Orderbon voor klant'                  , 'N', 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (4, 'Document voor eigen vertegenwoordiger', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'J', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (5, 'Intern documenten'                    , 'N', 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'J', 'N', 'N');



alter table ORDER4 add PRIJSAFSPRAAKNUMMER integer ; 
alter table ORDER2 add PRIJSAFSPRAAKNUMMER integer ; 

alter table ALGINST add   KL_FAK_NAAM                                  VARCHAR(100);
alter table ALGINST add   KL_FAK_STRAAT                                VARCHAR(100);
alter table ALGINST add   KL_FAK_HUISNR                                VARCHAR(10);
alter table ALGINST add   KL_FAK_PLAATS                                VARCHAR(100);
alter table ALGINST add   KL_FAK_PC                                    VARCHAR(10);
alter table ALGINST add   KL_FAK_BTW                                   VARCHAR(20);
alter table ALGINST add   KL_FAK_KVK                                   VARCHAR(20);
alter table ALGINST add   KL_FAK_TEL                                   VARCHAR(20);
alter table ALGINST add   KL_FAK_EMAIL                                 VARCHAR(100);
alter table ALGINST add   KL_FAK_IBAN                                  VARCHAR(30);
alter table ALGINST add   KL_FAK_BIC                                   VARCHAR(30);
alter table ALGINST add   XML_FACTUUR                                  CHAR(1);


SET TERM ^^ ;
CREATE OR ALTER PROCEDURE P_ORDER_FACTUUROBJECTDATA (
  ORDERNUMMER Integer, 
  OBV_OFFERTE Char(1))
 returns (
  WERK Integer, 
  KLANT Integer, 
  INTERNLEVERINGNUMMER Integer, 
  OFFERTENUMMER Integer, 
  OPDRACHTNR VarChar(50), 
  ONDERHOUD Char(1), 
  SOORT Char(1), 
  ORDERSOORT Integer, 
  BEGINDATUM Date, 
  EINDDATUM Date, 
  INIT_BEGINDATUM Date, 
  PLAN_BEGIN Date, 
  PLAN_EIND Date, 
  INIT_PLANEIND Date, 
  PLAN_DAGEN Integer, 
  PLAN_WEKEN Integer, 
  FAK_DATUM Date, 
  FAKTERMIJN Integer, 
  ZA Char(1), 
  ZO Char(1), 
  BTW_KODE Integer, 
  KLANTENKORTING Integer, 
  AUTO_CREDITPERC Double Precision, 
  PERCENTAGE_GREKENING Double Precision, 
  BLOKKEERSTAFFEL Char(1), 
  ORDERFAKTUURDEBITEUR Integer, 
  OPD_DATUM Date, 
  BEHANDELD Integer, 
  VERZEKER Double Precision, 
  VERZEKERINGTYPE Char(1), 
  STORINGSPERCENTAGE Integer, 
  ORDERTOESLAG Char(1), 
  FAK_DAGEN Integer, 
  VALUTA Integer, 
  FAKTUREREN Char(1), 
  FAK_PER_REGEL Char(1), 
  FAK_OVERIGEPERDIRECT Char(1), 
  VOORUITFAKTUREREN Char(1), 
  TOTAALBED Double Precision, 
  BEDRAG1 Double Precision, 
  RETOUR1 Date, 
  BEDRAG2 Double Precision, 
  RETOUR2 Date, 
  BEDRAG3 Double Precision, 
  RETOUR3 Date, 
  BEDRAG4 Double Precision, 
  RETOUR4 Date, 
  BEDRAG5 Double Precision, 
  RETOUR5 Date, 
  WEEKENDTOESLAG Char(1), 
  VERZENDWIJZE Integer, 
  VERZENDWIJZE_RETOUR Integer, 
  BESTELLER VarChar(40), 
  KLANTNAAM VarChar(40), 
  GROOTBOEK_VERZENDWIJZE VarChar(20), 
  GROOTBOEK_VERZENDWIJZE_RETOUR VarChar(20), 
  OP_VERZAMELFACTUUR Char(1), 
  REPORT_SUFFIX VarChar(10), 
  EERSTEORDERHUURDAGEN Date, 
  BEHANDELAAR_INITIALEN VarChar(10), 
  BEHANDELAARSNAAM VarChar(135), 
  DEBNR VarChar(13), 
  NEGERENBIJEXPORT Char(1), 
  TAALKODE Char(3), 
  EERSTEHUURTYPE Integer, 
  FACTUURDEBITEUR Integer, 
  FACT_DEBNR VarChar(13), 
  FACT_EFACTUUR Char(1), 
  FACT_EMAIL VarChar(100), 
  FACT_CONTACT VarChar(100), 
  WERK_NAAM VarChar(80), 
  WERK_PC VarChar(12), 
  WERK_PLAATS VarChar(40), 
  WERK_ADRES1 VarChar(100), 
  WERK_ADRES2 VarChar(100), 
  WERK_WERKNR Integer, 
  WERK_UITVOERDERSBON Char(1), 
  MAANDFAKTUUR Char(1), 
  KLANTCONTACT VarChar(30), 
  WERK_CONTACT VarChar(40), 
  VERTEGENWOORDIGER_EXACT VarChar(3), 
  WERK_BETALINGSCONDITIE VarChar(2), 
  KLANT_BETALINGSCONDITIE VarChar(2), 
  PROJECTLEIDER_NAAM VarChar(200), 
  PROJECTLEIDER_EMAIL VarChar(100), 
  PROJECTLEIDER_TELEFOON VarChar(30), 
  STAFFELKORTING Integer, 
  MAXAG_OPSLAG Integer, 
  WERK_BATCH Char(1), 
  KLANT_GRTB Integer, 
  FORCEER_TERMIJN Char(1), 
  EERSTE_ARTIKEL Integer, 
  EERSTE_ARTIKELGROEP Integer, 
  FAKTERMIJN_VAN_GROEP Integer)
SQL SECURITY INVOKER
AS
/*
  You can change this template in the template editor:
  File | Preferences | Object Templates

  Procedure:

  Author   : Dirk Janssens, 
  Date     : 4-11-2022 11:06:42
  Purpose  : Alle initele order-data die nodig is voor het TFaktuur-object om de factuur te kunnen maken
  Params
  ------
  <param>  : <purpose>
*/

declare n integer ;
declare O1_Projectleider integer ;

begin


SELECT

werk,
klant,
internleveringnummer,
OFFERTENUMMER,
OPDRACHTNR,
ONDERHOUD,
soort,
ordersoort,
begindatum,
einddatum,                             /*10*/
INIT_BEGINDATUM,
PLAN_BEGIN,
PLAN_EIND,
INIT_PLANEIND,
PLAN_DAGEN,
PLAN_WEKEN,
fak_Datum,
Faktermijn,
Za,
Zo,                                    /*20*/
btw_kode,
KLANTENKORTING,
AUTO_CREDITPERC,
PERCENTAGE_GREKENING,
BLOKKEERSTAFFEL ,
ORDERFAKTUURDEBITEUR,
OPD_DATUM,
BESTELLER,
BEHANDELD,                              /*30*/
VERZEKER,
VERZEKERINGTYPE,
STORINGSPERCENTAGE,
ORDERTOESLAG,
FAK_DAGEN,VALUTA,
faktureren,
fak_per_regel,
fak_overigeperdirect,
vooruitfaktureren,
TOTAALBED,                              /*40*/
BEDRAG1,
RETOUR1,
BEDRAG2,
RETOUR2,
BEDRAG3,
RETOUR3,
BEDRAG4,
RETOUR4,
BEDRAG5,
RETOUR5,
WEEKENDTOESLAG ,
VERZENDWIJZE,
VERZENDWIJZE_RETOUR,
PROJECTLEIDER


from order1 where nummer= :ordernummer into
:werk,
:klant,
:internleveringnummer,
:OFFERTENUMMER,
:OPDRACHTNR,
:ONDERHOUD,
:soort,
:ordersoort,
:begindatum,
:einddatum,                /*10*/
:INIT_BEGINDATUM,
:PLAN_BEGIN,
:PLAN_EIND,
:INIT_PLANEIND,
:PLAN_DAGEN,
:PLAN_WEKEN,
:fak_Datum,
:Faktermijn,
:Za,
:Zo,                       /*20*/
:btw_kode,
:KLANTENKORTING,
:AUTO_CREDITPERC,
:PERCENTAGE_GREKENING,
:BLOKKEERSTAFFEL ,
:ORDERFAKTUURDEBITEUR,
:OPD_DATUM,
:BESTELLER,
:BEHANDELD,
:VERZEKER,                 /*30*/
:VERZEKERINGTYPE,
:STORINGSPERCENTAGE,
:ORDERTOESLAG,
:FAK_DAGEN,VALUTA,
:faktureren,
:fak_per_regel,
:fak_overigeperdirect,
:vooruitfaktureren,
:TOTAALBED,
:BEDRAG1,                  /*40*/
:RETOUR1,
:BEDRAG2,
:RETOUR2,
:BEDRAG3,
:RETOUR3,
:BEDRAG4,
:RETOUR4,
:BEDRAG5,
:RETOUR5,
:WEEKENDTOESLAG ,          /*50*/
:VERZENDWIJZE,
:VERZENDWIJZE_RETOUR,
:O1_Projectleider;

select naam, debnr, DebiteurNegerenBijExport, taalkode, contact, MAANDFAKTUUR,VERTEGENWOORDIGER_EXACT,BETALINGSCONDITIE,STAFFELKORTING,
 ( select max( S.ARTIKELGROEPKORTING_OPSLAG  ) from  STAFFEL S where S.STAFFEL = Staffelkorting ),FORCEERTERMIJN  
from klant where nummer=:klant 
into :klantnaam, :Debnr, :NEGERENBIJEXPORT, :taalkode, :klantCOntact, :MAANDFAKTUUR, :VERTEGENWOORDIGER_EXACT, :KLANT_BETALINGSCONDITIE, :STAFFELKORTING, :maxAG_OPSLAG, :FORCEER_TERMIJN;

select grootboek from klant_grootboek where klant = :klant into :KLANT_GRTB ;

select G.kODE from grtb G where G.nummer =  (select grootboek from verzendwijze where nummer = :VERZENDWIJZE         )
into :GROOTBOEK_VERZENDWIJZE;

select G.kODE from grtb G where G.nummer =  (select grootboek from verzendwijze where nummer = :VERZENDWIJZE_RETOUR  )
into :GROOTBOEK_VERZENDWIJZE_RETOUR;

select OP_VERZAMELFACTUUR,REPORT_SUFFIX    from ordersoorten where nummer = :ordersoort
into :Op_Verzamelfactuur, :REPORT_SUFFIX ;

select first 1 ( OHD.DATUM ) from ORDER_HUURDAGEN OHD where OHD.ORDERNUMMER = :ordernummer
into :EersteOrderHuurdagen ;

select initialen,coalesce(WERKNEMERS.voornaam      || ' ' , WERKNEMERS.initialen || ' ','') || coalesce(WERKNEMERS.TUSSENVOEGSEL || ' ' , '') || coalesce(WERKNEMERS.naam , '')
from WERKNEMERS where nummer = :behandeld
into :Behandelaar_initialen, :BEHANDELAARSNAAM ;

if (OBV_OFFERTE = 'J') then
  select first 1 type_regel from order2 where nummer = :ordernummer and type_regel in (1,2,3,4,5,6,17) order by volgnummer into :EersteHuurtype ;
else
select first 1 type_regel from order4 where nummer = :ordernummer and type_regel in (1,2,3,4,5,6,17) order by volgnummer into :EersteHuurtype;


select BATCH_FAKTUUR from werk where nummer = :werk into :werk_batch ;
                                                                          
  if (:werk_batch='J') then begin 

    select FAKTUURDEBITEUR from werk where nummer =:werk into :n ;
     
    if ( n > 0) then 

      :Factuurdebiteur = :n ;

    else begin  

      select FAKTUURDEBITEUR from klant where nummer =:werk into :n ;

      if (n > 0)then 
        :Factuurdebiteur = :n ;
      else
        :Factuurdebiteur = :KLant ;

    end
  
  end else begin

    if      ( :ORDERFAKTUURDEBITEUR > 0)  then

     :Factuurdebiteur = :ORDERFAKTUURDEBITEUR ;

    else begin 

      select FAKTUURDEBITEUR from werk where nummer = :werk into :n ;

      if (:n > 0 ) then
       :Factuurdebiteur = :n ;

      else begin 

        select FAKTUURDEBITEUR from klant where nummer = :werk into :n ;
  
        if ( :n > 0)then
         :Factuurdebiteur = :n ; 
       else
         :Factuurdebiteur = :KLANT;

      end
      
    end
    
    
  end    

                               
  if (:klant=:Factuurdebiteur) then begin
                                        
    :fact_debnr = :debnr ;
    
    select 
    EFACTUUR, 
    Coalesce(klant.Email2,klant.Email1) ,                                       
    Coalesce(CONTACT_EXACT,Contact, TAV, Naam )from KLANT where Klant.NUMMER =  :klant into :FACT_EFACTUUR, :FACT_EMAIL, :FACT_CONTACT ; 
  
  end else begin
  
    select 
    DEBNR,
    EFACTUUR, 
    Coalesce(klant.Email2,klant.Email1) , 
    Coalesce(CONTACT_EXACT,Contact, TAV, Naam )from KLANT where Klant.NUMMER =  :Factuurdebiteur into :fact_debnr, :FACT_EFACTUUR, :FACT_EMAIL, :FACT_CONTACT; 

  end
  

  select naam,pc,plaats, adres1,adres2,werknummer, uitvoerdersbon, contact, BETALINGSCONDITIE
  from werk where nummer = :werk 
  into  :Werk_naam, :Werk_PC, werk_plaats,  :Werk_adres1, :WErk_adres2, :WERK_WERKNR, :WERK_uitvoerdersbon, :WERK_CONTACT,:WERK_BETALINGSCONDITIE ;
                                                                     
  if ( :OPDRACHTNR = '')then
    select opdrachtnummer  from werk where nummer = :werk into :OPDRACHTNR ;
                                                                       
    

  select coalesce(ADRESBOEK.voornaam      || ' ' , ADRESBOEK.initialen || ' ','') || coalesce(ADRESBOEK.TUSSENVOEGSEL || ' ' , '')|| coalesce(ADRESBOEK.naam , ''),
          EMAIL,TELEFOON 
  from ADRESBOEK where nummer = :O1_PROJECTLEIDER 
  into :PROJECTLEIDER_NAAM, :PROJECTLEIDER_EMAIL, :PROJECTLEIDER_TELEFOON ;   
                   
  if (OBV_OFFERTE = 'J') then 
   select first 1 artikel from order2 where nummer = :ordernummer order by volgnummer into :Eerste_ARtikel ;
  else  
   select first 1 artikel from order4 where nummer = :ordernummer order by volgnummer into :Eerste_ARtikel ;
  
  select groep from artikel where nummer = :eerste_Artikel into :Eerste_artikelgroep ;
  
  select FAKTERMIJN from GROEP where nummer = :EERSTE_ARTIKELGROEP into :FAKTERMIJN_VAN_GROEP ; 
   
suspend;



end ^^
SET TERM ; ^^

alter table GROEP Add DEFAULT_ORDERSOORT integer ;
commit;

alter table report_globals add Adresblok4 Varchar(255) ;
alter table report_globals add LOGO5 BLOB SUB_TYPE 0 SEGMENT SIZE 80;  
alter table report_globals add LOGO6 BLOB SUB_TYPE 0 SEGMENT SIZE 80;
alter table report_globals add LOGO7 BLOB SUB_TYPE 0 SEGMENT SIZE 80;
alter table report_globals add LOGO8 BLOB SUB_TYPE 0 SEGMENT SIZE 80;
alter table report_globals add Memo4 BLOB SUB_TYPE 1 SEGMENT SIZE 80;    
alter table report_globals add Memo5 BLOB SUB_TYPE 1 SEGMENT SIZE 80;    
alter table report_globals add Memo6 BLOB SUB_TYPE 1 SEGMENT SIZE 80;
alter table report_globals add Memo7 BLOB SUB_TYPE 1 SEGMENT SIZE 80;
alter table report_globals add Memo8 BLOB SUB_TYPE 1 SEGMENT SIZE 80;              
 
alter table report_globals add Tekstblok1 Varchar(255);
alter table report_globals add Tekstblok2 Varchar(255);
alter table report_globals add Tekstblok3 Varchar(255);
alter table report_globals add Tekstblok4 Varchar(255);
alter table report_globals add Tekstblok5 Varchar(255);
alter table report_globals add Tekstblok6 Varchar(255);
alter table report_globals add Tekstblok7 Varchar(255);
alter table report_globals add Tekstblok8 Varchar(255);
 
commit;
alter table ORDER1_FOTOS add SOORT integer ;
commit;
 
alter table LOGTYPE  add IMAGEINDEX integer ;
alter table ORDERLOG add TERUGBELLEN CHAR(1);
commit;
 


alter table ORDER2 add VOLGORDE integer ;
commit;
 

update PP_WAGENPLANNING set ITEMPOS = ITEMPOS+2 where ITEMPOS > 3;
update PP_PLOEG_VAN_ITEMPOS set ITEMPOS = ITEMPOS+2 where ITEMPOS > 3;
update PLOEGENPLANNING set ITEMPOS = itempos+2 where ITEMPOS>3;

commit;

alter table order1 add RONDE_PERIODE integer ;
alter table order1 add RONDE_KLANTBELLEN CHAR(1) ;
commit;

update order1 set RONDE_PERIODE = 7 where ronde is not null ;
update order1 set RONDE_KLANTBELLEN = 'N' where ronde is not null ;

SET TERM ^^ ;
CREATE TRIGGER ORDER4_INSERT FOR ORDER4 ACTIVE AFTER INSERT POSITION 0 SQL SECURITY INVOKER AS

  declare variable Groep    integer ;
  declare variable Werknummer integer ;
  declare variable RondeRelevant integer ;
  
begin
  
  RondeRelevant = 0;      
  
  select groep from artikel where nummer = NEW.ARTIKEL into :Groep;
  
  Select count(groep) from ARTIKELGROEPEN_RONDE AR where AR.GROEP = :groep into :RondeRelevant;
                                
  if ( RondeRelevant > 0 ) then begin 
  
   select werk from order1 where order1.nummer = NEW.NUMMER into :werknummer ;
   update order1 set RONDE = (select coalesce( RONDE,0) from WERK where WERK.NUMMER = :WERKNUMMER) where order1.nummer = NEW.NUMMER ;

  end 
  
end
 ^^
SET TERM ; ^^

CREATE TABLE IVS_RECENT_GEOPENDEORDERS 
(
  NUMMER                        INTEGER         NOT NULL,
  BEHANDELAAR                   INTEGER         NOT NULL,
  DATUM                            DATE,
  BEHANDELAAR_NAAM              VARCHAR(50),
  INFO                          VARCHAR(250),
  CONSTRAINT PK_IVS_RECENT_GEOPENDEORDERS PRIMARY KEY (NUMMER, BEHANDELAAR)
);
commit;

SET TERM ^^ ;
CREATE OR ALTER PROCEDURE SET_RECENTGEOPEND_CALC (
  ORDERNUMMER Integer, 
  BEHANDELAAR Integer)
SQL SECURITY INVOKER
AS
declare variable sInfo varchar(250) ;
declare variable s40 varchar(40) ;
declare variable s80 varchar(80) ;
declare variable internleveringnummer integer ;
declare variable internoffertenummer  integer ;
declare variable sNummer varchar(20)  ;

begin
  select naam from klant where nummer = ( select klant from order1 where nummer=:ORDERNUMMER )  into :s40 ;
  select naam from werk  where nummer = ( select werk  from order1 where nummer=:ORDERNUMMER )  into :s80 ;
  select internleveringnummer from order1 where nummer =:ORDERNUMMER into :internleveringnummer;
  
  if ( ( internleveringnummer is null) or (internleveringnummer<=0) ) then begin
   select :internoffertenummer from order1 where nummer =:ordernummer into :internoffertenummer ;   sNummer = 'Offerte '||internoffertenummer;                                     
  end else 
   sNummer = 'Order '||internleveringnummer;  
   
/* te lastig om actueel te houden: gewoon ophalen uit order1  select OMSCHRIJVING from order1 where nummer =NEW.NUMMER into :s250;
  sinfo = substring( sNummer||'#10#13'||s40||'#10#13'||s80||'#10#13'||sInfo from 1 for 250 );*/   

  sinfo = substring( sNummer||' van klant '||s40||ASCII_CHAR(13)||ASCII_CHAR(10)||'werk:'||s80 from 1 for 250 );   

  update IVS_RECENT_GEOPENDEORDERS 
         
         set BEHANDELAAR_NAAM = (select coalesce( W.VOORNAAM ||' ' , '')  || W.naam from WERKNEMERS W where W.nummer = :BEHANDELAAR), 
         INFO = :sInfo 
  where IVS_RECENT_GEOPENDEORDERS.nummer = :ORDERNUMMER ;

                                      
    
end ^^
SET TERM ; ^^
commit;

SET TERM ^^ ;
CREATE TRIGGER IVS_RECENT_GEOPENDEORDERS FOR IVS_RECENT_GEOPENDEORDERS ACTIVE AFTER INSERT POSITION 0 SQL SECURITY INVOKER AS
begin


  EXECUTE PROCEDURE SET_RECENTGEOPEND_CALC(NEW.nummer, NEW.BEHANDELAAR) ;
  
  post_event('NIEUW_RECENT_GEOPENDEORDERS') ;     
    
end
 ^^
SET TERM ; ^^



CREATE TABLE IVS_RECENT_GEOPEND 
(
  NUMMER                   INTEGER         NOT NULL,
  BEHANDELAAR              INTEGER         NOT NULL,
  DATUM       TIMESTAMP WITH TIME ZONE         DEFAULT LOCALTIMESTAMP,
  CONSTRAINT PK_IVS_RECENT_GEOPEND PRIMARY KEY (NUMMER, BEHANDELAAR)
);


CREATE TABLE IVS_GEBRUIKERSLOGBOEK 
(
  NUMMER                   INTEGER         NOT NULL,
  TIJDSTEMPEL TIMESTAMP WITH TIME ZONE         DEFAULT LOCALTIMESTAMP,
  BEHANDELAAR              INTEGER,
  ACTIE                    INTEGER,
  KLANT                    INTEGER,
  WERK                     INTEGER,
  ORDERNUMMER              INTEGER,
  BESTELLING               INTEGER,
  BEURT                    INTEGER,
  CONSTRAINT PK_IVS_GEBRUIKERSLOGBOEK PRIMARY KEY (NUMMER)
);



CREATE TABLE IVS_ACTIES 
(
  NUMMER                    INTEGER         NOT NULL,
  OMSCHRIJVING              VARCHAR(250),
  CONSTRAINT PK_IVS_ACTIES PRIMARY KEY (NUMMER)
);
commit;


/*
  IVS_ACTIES
  ----------
  Exporting all rows
*/
INSERT INTO IVS_ACTIES (NUMMER, OMSCHRIJVING) VALUES (1, 'Nieuwe Klant');
INSERT INTO IVS_ACTIES (NUMMER, OMSCHRIJVING) VALUES (2, 'Nieuw Werk');
INSERT INTO IVS_ACTIES (NUMMER, OMSCHRIJVING) VALUES (3, 'Nieuwe Offerte ');
INSERT INTO IVS_ACTIES (NUMMER, OMSCHRIJVING) VALUES (4, 'Nieuwe Order ');
INSERT INTO IVS_ACTIES (NUMMER, OMSCHRIJVING) VALUES (5, 'Nieuwe Onderhoudsbeurt ');
INSERT INTO IVS_ACTIES (NUMMER, OMSCHRIJVING) VALUES (6, 'Bestelling geplaats');
INSERT INTO IVS_ACTIES (NUMMER, OMSCHRIJVING) VALUES (7, 'Orderafgemeld');
/* 7 row(s) exported */


commit;

SET TERM ^^ ;
CREATE TRIGGER IVS_RECENT_GEOPEND_ FOR IVS_RECENT_GEOPEND ACTIVE AFTER INSERT POSITION 0 SQL SECURITY INVOKER AS
begin
                                      
   update IVS_RECENT_GEOPEND set CALC_KLANT           = (select naam from klant where nummer = (select klant from order1 where nummer=NEW.NUMMER) ) where IVS_RECENT_GEOPEND.nummer = NEW.NUMMER;
   update IVS_RECENT_GEOPEND set CALC_WERK            = (select naam from werk  where nummer = (select werk  from order1 where nummer=NEW.NUMMER) ) where IVS_RECENT_GEOPEND.nummer = NEW.NUMMER;
   update IVS_RECENT_GEOPEND set CALC_OFFERTENUMMER   = (select INTERNOFFERTENUMMER from order1  where nummer =NEW.NUMMER )                           where IVS_RECENT_GEOPEND.nummer = NEW.NUMMER  ;
   update IVS_RECENT_GEOPEND set CALC_LEVERINGNUMMER  = (select internleveringnummer from order1  where order1.nummer =NEW.NUMMER )                   where IVS_RECENT_GEOPEND.nummer = NEW.NUMMER ;
   update IVS_RECENT_GEOPEND set CALC_BEHANDELAAR     = (select naam from werknemers where nummer =NEW.BEHANDELAAR )                                  where IVS_RECENT_GEOPEND.nummer = NEW.NUMMER ;

   post_event('NIEUW_RECENT_GEOPEND') ;     
    
end
 ^^
SET TERM ; ^^


CREATE TRIGGER IVS_GEBRUIKERSLOGBOEK_ FOR IVS_GEBRUIKERSLOGBOEK ACTIVE AFTER INSERT POSITION 0 SQL SECURITY INVOKER AS
begin
  post_event('NIEUWE_IVS_ACTIE') ; 
end
 ^^

CREATE OR ALTER PROCEDURE SET_ORDEROMSCHRIJVING (
  NUMMER Integer)
SQL SECURITY INVOKER
AS
/*
  You can change this template in the template editor:
  File | Preferences | Object Templates

  Procedure:

  Author   : Dirk Janssens, 
  Date     : 27-1-2023 11:03:33
  Purpose  : Het bepalen en opslaan van de order omschrijving
  Params
  ------
  <param>  : <purpose>
*/
declare variable soort   varchar(30) ; 
declare variable eersteartikel varchar(255) ;
 
begin
  /* code */            
                                                            
 select omschrijving from ORDERSOORTEN where nummer =  ( select  SOORT  from order1 where nummer = :NUMMER)  into :soort ;

select OMSCHRIJVING from order4 where( (nummer = :NUMMER) and (VOLGNUMMER =1))  into :eersteartikel ;

if (eersteartikel is null) then 
 select OMSCHRIJVING from order2 where( (nummer = :NUMMER) and (VOLGNUMMER =1))  into :eersteartikel ;

if (eersteartikel is null) then eersteARtikel = '(nog geen artikelen)' ;
 

update order1 set OMSCHRIJVING = SUBSTRING( :eersteartikel from 1 for 50) where nummer = :nummer ;     


    
  
end ^^
SET TERM ; ^^


alter table werk_fotos add soort integer ;
commit;

DROP TABLE IVS_DOCUMENTSOORT ;
commit;

CREATE TABLE IVS_DOCUMENTSOORT 
(
  NUMMER                                    INTEGER         NOT NULL,
  OMSCHRIJVING                              VARCHAR(50),
  INHUURDOCUMENT                               CHAR(1),
  FACTUUR                                      CHAR(1),
  ORDERBON                                     CHAR(1),
  RECIP_KLANT_EMAIL1                           CHAR(1),
  RECIP_KLANT_EMAIL2                           CHAR(1),
  RECIP_PROJECTLEIDER                          CHAR(1),
  RECIP_BESTELLER                              CHAR(1),
  RECIP_ORDERCONTACTEN                         CHAR(1),
  RECIP_INTERN                                 CHAR(1),
  RECIP_EIGENVERTEGENWOORDIGER                 CHAR(1),
  RECIP_VERTEGENWOORDIGE                       CHAR(1),
  CONSTRAINT PK_IVS_DOCUMENTSOORT PRIMARY KEY (NUMMER)
);



commit; 

INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (1, 'Factuur', 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (2, 'Inhuurdocument', 'J', 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (3, 'Orderbon voor klant', 'N', 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (4, 'Document voor eigen vertegenwoordiger', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'j', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (5, 'Intern documenten', 'N', 'N', 'J', 'N', 'N', 'N', 'N', 'N', 'J', 'N', 'N');
INSERT INTO IVS_DOCUMENTSOORT (NUMMER, OMSCHRIJVING, INHUURDOCUMENT, FACTUUR, ORDERBON, RECIP_KLANT_EMAIL1, RECIP_KLANT_EMAIL2, RECIP_PROJECTLEIDER, RECIP_BESTELLER, RECIP_ORDERCONTACTEN, RECIP_INTERN, RECIP_EIGENVERTEGENWOORDIGER, RECIP_VERTEGENWOORDIGE) VALUES (6, 'Overzicht', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'J', 'J', 'N');


update artikel set imagefile = null where IMAGEFILE = '' ;

update alginst set BUILD = 32543 ;

